//Implementace vstupu a vystupu pro DOS (Borland C)

//Standardni knihovny
#include <stdio.h>
#include <stdlib.h>

//Platform-dependent (DOS) knihovny
#include <conio.h>
#include <time.h>
#include <dos.h>

#include "tetris.h"

#define SQ0 "  " //Prazdny ctverecek
#define SQ1 "[]" //Znaky tvorici ctverecek
#define SQ2 "" //Zvyrazneny ctverecek
#define SQ3 "::" //Alternativni ctverecek

int limit; //Casovy limit, po kterem kostka spadne (v setinach sekundy)
int offset; //O kolik je posunute doprava to, co se vykresluje


//Vykresli natoceni kostky SHAPE na souradnice C, ctverecek bude symbol STR
void draw_shape(T_SHAPE *shape, T_COORD *c, char *str)
{
  int i;

  for(i = 0; i < 4; i++)
  {
    gotoxy(2 * (shape->sq[i].x + c->x) + 1 + offset, shape->sq[i].y + c->y + 1);
    printf(str);
  }
  gotoxy(80,25); //Zahodi kurzor do rohu
}


//Vykresli radky od Y1 do Y2 (vcetne!) z pole BOARD
void draw_rows(int y1, int y2, T_BOARD board)
{
  int x,y; //Indexy cyklu - radek, sloupec

  for(y = y1; y <= y2; y++)
    for(x = 1; x < 11; x++)
    {
      gotoxy(2 * x + 1 + offset, y + 1);
      if(board[x][y])
        printf(SQ1);
      else
        printf(SQ0);
    }

  gotoxy(80,25); //Zahodi kurzor do rohu
}


//Vypis statistickych udaju hry GAME
void show_stats(T_GAME *game)
{
  int i;

  if (game->mode == GAME_MATCH)
    i = game->player ? 35 : 30;
  else
    i = 33;

  gotoxy(i + 15,4);  printf("%d", game->stats.all_rows);
  gotoxy(i + 15,5);  printf("%d", game->stats.rows_by_number[1]);
  gotoxy(i + 15,6);  printf("%d", game->stats.rows_by_number[2]);
  gotoxy(i + 15,7);  printf("%d", game->stats.rows_by_number[3]);
  gotoxy(i + 15,8);  printf("%d", game->stats.rows_by_number[4]);

  gotoxy(48,10);  printf("%d", game->stats.all_bricks);
  gotoxy(39,12);  printf("%d", game->stats.single_brick[0]);
  gotoxy(49,12); printf("%d", game->stats.single_brick[2]);
  gotoxy(39,14);  printf("%d", game->stats.single_brick[3]);
  gotoxy(49,14); printf("%d", game->stats.single_brick[4]);
  gotoxy(39,16);  printf("%d", game->stats.single_brick[5]);
  gotoxy(49,16); printf("%d", game->stats.single_brick[6]);
  gotoxy(39,18);  printf("%d", game->stats.single_brick[1]);

  if(game->mode == GAME_COMP)
  {
    gotoxy(49,22); printf("%d  ", game->stats.qual);
  }
}


//Oznameni o prohre
void game_over()
{
  gotoxy(9 + offset,1);
  printf("GAME OVER !"); //Ale hral jsi dobre... budes mi chybet...
  gotoxy(13,1); //Kurzor mezi E a O
  delay(2000); //Aby sis to stihnul vychutnat (2 sekundy)
}


//Uvodni obrazovka (zavisi na typu hry GAMEMODE), dotaz na rychlost hry
void introduction(int gamemode)
{
  clrscr();
  gotoxy(37,2);
  printf("TETRIS\n\n");

  switch(gamemode)
  {
    case GAME_HUMAN:
      break;

    case GAME_COMP:
      printf("Pocitac bude hrat sam podle programu.\n");
      printf("(Testuje se kazda pozice a hodnoti body. Za diru je -%d bodu,\n", COEF1);
      printf(" za vymazanou radu %d bodu a za kazdou jednotku rozdilu vysek\n", COEF2);
      printf(" nad tri -%d bodu.)\n", COEF3);
      printf("Vy se muzete jen divat jak mu to jde.\n");
      printf("Az vas to prestane bavit, stisknete ESC.\n\n");
      printf("Muzete si ale zvolit, za jakou dobu (v setinach sekundy)\n");
      printf("pocitac polozi kostku. Muzete zadat i nulu.\n");
      printf("Pak toho sice moc neuvidite, ale zjistite, jak mate rychly pocitac.\n\n");
      break;

    case GAME_HELP:
      printf("Normalni tetris, az na to, ze pocitac vybere nejlepsi pozici pro kostku\n");
      printf("podle sveho algoritmu a ukaze ji. Vy muzete samozrejme polozit kostku\n");
      printf("kam chcete. Program nebyl vytvoren pro hrace s ponekud snizenou inteligenci,\n");
      printf("ale spise abyste mohli snadno porovnat kvalitu algoritmu.\n\n");
      break;

    case GAME_MATCH:
      printf("Zahrajte si Tetris proti docela jednoduchemu algoritmu!\n");
      printf("(Testuje se kazda pozice a hodnoti body. Za diru je -%d bodu,\n", COEF1);
      printf(" za vymazanou radu %d bodu a za kazdou jednotku rozdilu vysek\n", COEF2);
      printf(" nad tri -%d bodu.)\n\n", COEF3);
      break;
  }

  if(gamemode != GAME_COMP) /* Vsechny hry krome hry pocitace */
  {                         /* maji stejne ovladani           */
    printf("Ovladani:\n");
    printf("  sipky \x11 \x1F \x10 - posun kostky\n");
    printf("  pismena Z, X - otaceni kostky po, proti smeru hodinovych rucicek\n");
    printf("  mezernik - pauza\n");
    printf("  ESC - konec programu\n\n");
    printf("Rychlost hry (tj. cas mezi pady kostky v setinach sekundy):\n");
    printf("100 - pohodicka, 50 - normalni, 10 - drsnarna, 5 - sebevrazda\n\n");
  }

  printf("Tak na kolik se dnes citite ? ");
  scanf("%d", &limit);
}


//Pripravi obrazovku pro zadanou hru: ramecek okolo pole, statistika apod.
void prepare_screen(int gamemode)
{
  int i; //Index cyklu

  clrscr();

  //Statisticke informace budou v prave polovine obrazovky
  gotoxy(30,1);  printf("      STATISTIKA");
  gotoxy(30,2);  printf("     Rychlost: %d", limit);
  gotoxy(30,10); printf("   Kostky celkem:  ");
  gotoxy(30,12); printf("     :      :  ");
  gotoxy(30,14); printf("    :      :  ");
  gotoxy(30,16); printf("    :      :  ");
  gotoxy(30,18); printf("   :  ");

  i = (gamemode == GAME_MATCH) ? 0 : 3;
  gotoxy(30 + i, 4);  printf("Vymazane rady:  ");
  gotoxy(30 + i, 5);  printf("  jednoduse:  ");
  gotoxy(30 + i, 6);  printf("  2 zaroven:  ");
  gotoxy(30 + i, 7);  printf("  3 zaroven:  ");
  gotoxy(30 + i, 8);  printf("  4 zaroven:  ");

  if(gamemode == GAME_MATCH)
  {
    gotoxy(30,3); printf("               Ty   On");
  }

  if(gamemode == GAME_COMP) /* Zobrazeni ovladani (nebo vyhodnosti */
  {                         /* pozice, pokud hraje pocitac sam)    */
    gotoxy(30,20); printf(" Konec: ESC\n");
    gotoxy(30,22); printf(" Vyhodnost pozice:\n");
  }
  else
  {
    gotoxy(30,20); printf(" OVLADANI:");
    gotoxy(30,21); printf(" sipky \x11 \x1F \x10 - posun");
    gotoxy(30,22); printf(" pismena Z, X - otaceni");
    gotoxy(30,23); printf(" mezernik - pauza");
    gotoxy(30,24); printf(" ESC - konec programu");
  }
}


//Kresleni ramecku okolo pole
void draw_frame()
{
  int i; //Index cyklu

  for(i = 0; i < 12; i++)
  {
    gotoxy(2 * i + 1 + offset, 25);
    printf(SQ1);
  }
  for(i = 0; i < 25; i++)
  {
    gotoxy(1 + offset, i + 1);
    printf(SQ1);
    gotoxy(23 + offset, i + 1);
    printf(SQ1);
  }
}

//Zepta se na typ hry, vrati zadanou hodnotu
int select_mode()
{
  int gamemode;

  clrscr();
  gotoxy(37,2);
  printf("TETRIS\n\n");

  printf("Zvolte typ hry:\n");
  printf("1) Standardni Tetris\n");
  printf("2) Automaticka hra - misto vas bude hrat pocitac\n");
  printf("3) Hra s napovedou - pocitac ukazuje, kam by kostku polozil\n");
  printf("4) Hra proti pocitaci\n");
  printf("\nTak co si vyberete? (Zadejte cislo): ");
  scanf("%d", &gamemode);
  return gamemode - 1;
}


//Nastavi, ze se bude kreslit do okna WINDOW
void select_window(int window)
{
  offset = window ? 55 : 1; //Je-li okno 1, posune se vsechno o 20 znaku
}


//Cekani na stisk klavesy nebo konec limitu, vrati stisknutou klavesu
char wait()
{
  char ch = 0; //Stisknuta klavesa
  static int cas = -1; //Cas posledniho padu kostky
  struct time akt_cas; //Aktualni cas (pocet setin sekundy)

  if(cas == -1) /* Prvni volani fukce: promenna CAS */
  {             /* se inicializuje aktualnim casem  */
    gettime(&akt_cas);
    cas = (100 * akt_cas.ti_sec + akt_cas.ti_hund);
  }

  while(!ch) /* Cekani na stisk klavesy, pokud neni stisknuta do konce */
  {          /*  limitu, kostka spadne jako pri stisku sipky dolu      */
    gettime(&akt_cas); //Nacte aktualni cas
    if(((100 * akt_cas.ti_sec + akt_cas.ti_hund - cas + 6000) % 6000) >= limit)
    { //Porovnani rozdilu casu s limitem, pocita se modulo 1 minuta
      cas = (100 * akt_cas.ti_sec + akt_cas.ti_hund);
      ch = 'P'; //Jakoby byla stisknuta sipka dolu
    }
    else if(kbhit()) /* Pokud byla stisknuta */
      ch = getch();  /* klavesa, vratime ji  */
  }

  return ch; //Vratime stisknutou klavesu
}


//Clovek polozi kostku BRICK ve hre GAME, pokud SHOW_HELP, zobrazi napovedu
//Funkce vraci 0, pokud ma program zkoncit, jinak 1
int select_human(T_BRICK *brick, T_GAME *game, int show_help)
{
  char ch; //Stisknuta klavesa
  int command; //Prikaz odpovidajici stisknute klavese
  T_COORD c = START_POS; //Souradnice kostky a jeji otoceni
  T_COORD c_help = START_POS; //Kam by kostku polosil pocitac

  if(show_help)                     /* Pokud se ma zobrazovat napoveda, */
    find_pos(brick, &c_help, game); /* vypocita se pozice pto kostku    */

  while(1)
  {
    if(show_help) //Napoveda - kam by kostku polozil pocitac
      draw_shape(&brick->rot[c_help.r], &c_help, SQ3);

    draw_shape(&brick->rot[c.r], &c, SQ1); //Zobrazovani kostky

    ch = wait(); //Cekani na stisk klavesy nebo konec limitu

    draw_shape(&brick->rot[c.r], &c, SQ0); //Mazani puvodni pozice kostky

    switch(ch) //Misto stisknute klavesy vrati odpovidajici konstantu
    {
      case 27: return 0; //Konec
      case ' ': getch(); break; //Pauza
      case 'K': command = KEY_LEFT; break; //Doleva
      case 'M': command = KEY_RIGHT; break; //Doprava
      case 'P': command = KEY_DOWN; break; //Dolu
      case 'z': command = KEY_RROT; break; /* Otoceni po smeru   */
      case 'Z': command = KEY_RROT; break; /* hodinovych rucicek */
      case 'x': command = KEY_LROT; break; /* Otoceni proti smeru */
      case 'X': command = KEY_LROT; break; /* hodinovych rucicek  */
      case 13:  command = KEY_FALL; break; //Dopad kostky
      default: command = KEY_OTHER; break; //Jina klavesa (nedela nic)
    }

    if(!move_brick(command, &c, brick, game->board)) /* Pokud kostka */
    {                                               /* dopadla      */
      if(show_help) //Napoveda se maze
        draw_shape(&brick->rot[c_help.r], &c_help, SQ0);

      draw_shape(&brick->rot[c.r], &c, SQ1); //Kostka se znovu vykresli

      if(!set_brick(&brick->rot[c.r], &c, game)) /* Kostka se polozi,     */
      {                                          /* zustala-li ve vychozi */
        game_over();                             /* pozici, hra konci     */
        return 0;
      }

      if(game->last_changed != -1) //Pokud se rady zmenily, vykresli se
        draw_rows(game->first_changed, game->last_changed, game->board);

      show_stats(game); //Vypis statistickych udaju
      return 1; //Oznameni, ze kostka dopadla (0 znamena konec programu)
    }
  }
}


//Pocitac polozi kostku BRICK ve hre GAME, pokud SHOW_HELP, zobrazi napovedu
//Funkce vraci 0, pokud ma program zkoncit, jinak 1
int select_comp(T_BRICK *brick, T_GAME *game)
{
  T_COORD c = START_POS; //Souradnice kostky a jeji otoceni

  //Vyber pozice pro kostku, vyhodnost se uklada do statistiky
  game->stats.qual = find_pos(brick, &c, game) - c.y;

  draw_shape(&brick->rot[c.r], &c, SQ2); //Napred se polozena kostka zvyrazni

  if(kbhit() && getch() == 27) //Pro pripadne ukonceni
    return 0;
  delay(limit); //Pauzicka pro pozorovatele

  draw_shape(&brick->rot[c.r], &c, SQ1); //A potom zobrazi normalne

  if(!set_brick(&brick->rot[c.r], &c, game)) /* Kostka se polozi, pokud */
  {                                          /* zustala ve vychozi      */
    game_over();                             /* pozici, hra konci       */
    return 0;
  }

  if(game->last_changed != -1) //Pokud se rady zmenily, vykresli se
    draw_rows(game->first_changed, game->last_changed, game->board);
  show_stats(game); //Vypis statistickych udaju

  return 1;
}


// -= MAIN =-
int main()
{
  T_BRICK bricks[7]; //Data o kostkach
  T_BRICK *brick; //Vybrana kostka
  T_GAME game1, game2; //Udaje o hre
  int gamemode; //Druh hry

  //textmode(79); //80 sloupcu, 25 radek
  randomize(); //Pro opravdu nahodne kostky

  if(!read_bricks(bricks)) //Nacteni a vypocet udaju o kostkach
  {
    printf("Nelze precist udaje o kostkach (tetris.dat)!");
    return 1;
  }

  initialize(&game1); /* Inicializace  */
  initialize(&game2); /* struktur GAME */

  gamemode = select_mode(); //Zepta se uzivatele na typ hry
  game1.mode = game2.mode = gamemode; //Typ hry se zapise do struktur GAME
  game1.player = 0; /* Uklada se     */
  game2.player = 1; /* i cislo hrace */

  introduction(gamemode); //Uvodni obrazovka
  prepare_screen(gamemode); //Priprava obrazovky
  show_stats(&game1); //Vypis statistickych udaju
  select_window(0); //Zvoli se pole prvniho hrace
  draw_frame(); //Vykresli se ramecek okolo pole

  switch(gamemode)
  {
    case GAME_HUMAN: //Standardni hra
      do {
        brick = new_brick(bricks, &game1); //Nahodny vyber kostky
      } while(select_human(brick, &game1, 0)); //Dokud clovek polozil kostku
      break;

    case GAME_COMP: //Pocitac hraje sam
      do {
        brick = new_brick(bricks, &game1); //Nahodny vyber kostky
      } while(select_comp(brick, &game1)); //Dokud pocitac polozil kostku
      break;

    case GAME_HELP: //Pocitac ukazuje, kam by kostku polozil
      do {
        brick = new_brick(bricks, &game1); //Nahodny vyber kostky
      } while(select_human(brick, &game1, 1));
      break; //Dokud clovek polozil kostku, 1 znamena zobrazeni napovedy

    case GAME_MATCH: //Hra cloveka proti pocitaci
      select_window(1);   /* Vykresli se ramecek       */
      draw_frame();       /* i pro druheho hrace       */
      show_stats(&game2); /* a zobrazi jeho statistika */
      while(1)
      {
        brick = new_brick(bricks, &game1); //Nahodny vyber kostky

        //Clovek polozi kostku
        select_window(0);
        if(!select_human(brick, &game1, 0))
          break;

        //Pocitac polozi kostku
        select_window(1);
        if(!select_comp(brick, &game2))
          break;
      }
      break;
  }
  return 0;
}

