#include <iostream>

#include "LinkedList.h"
#include "ArrayList.h"

//NOTE: Switch between ArrayList and LinkedList here!
//typedef ArrayList<int> List;
typedef LinkedList<int> List;

using namespace std;

int main(void)
{
  List list;
  
  list.Add(0);
  list.Add(1);
  list.Add(3,3);
  list.Add(2,2);
  
  try {
    cout << list.IndexOf(2) << endl;
    cout << list.IndexOf(999);
  }
  
  catch(const runtime_error e)
  {
    cout << e.what() << endl;
  }
  
  try {
    list.Add(1,1);
  }
  
  catch(const runtime_error e)
  {
    cout << e.what() << endl;
  }
  
  list[1] = 9;
  list[8] = 8;
  
  try {
    list.RemoveIndex(3);
    list.RemoveIndex(0);
    list.RemoveIndex(8);
    list.RemoveIndex(3);
  }
  
  catch(const runtime_error e)
  {
    cout << e.what() << endl;
  }
  
  for(List::iterator it = list.Begin(); it != list.End(); ++it)
    cout << *it << ' ';
  cout << endl;
  
  return 0;
}
