#ifndef _LINKEDLIST_H_
#define _LINKEDLIST_H_

#include "ListExcept.h"

template <typename T> class LinkedList 
{
  private:
    
    struct LinkedListItem { int index; T data; struct LinkedListItem *next; };
    LinkedListItem *m_first, *m_last;
    int m_size;
  
  public:
    
    // Iterator
    class iterator 
    { 
      public:
        iterator() : m_item(0) {}
        T &operator* () { return m_item->data; }
        bool operator!= (const iterator &it) { return m_item != it.m_item; }
        bool operator== (const iterator &it) { return m_item == it.m_item; }
        
        iterator &operator++ () 
        { 
          m_item = m_item->next; 
          return *this; 
        }
        
      private:
        iterator(LinkedListItem *item) : m_item(item) {}
        LinkedListItem *m_item;
      
      friend class LinkedList;
    };
   
    // Constructor
    LinkedList() : m_first(0), m_last(0), m_size(0) {}
    
    // Prida objekt (object) na danou pozici (index) v seznamu. Index muze ukazovat i za konec
    // seznamu.
    void Add(int index, T object)
    {     
      LinkedListItem **p;
      
      for(p = &m_first; *p; p = &(*p)->next)
      {  
        if(index == (*p)->index)
          throw existing();
          
        if(index < (*p)->index)
          break;
      }
     
      insert(p,object,index);
    }

    // Prida objekt (object) na konec seznamu.
    void Add(T object)
    {
      if(!m_last)
        insert(&m_first,object,m_size);
      else
        insert(&m_last->next,object,m_size);
    }

    // Vrati true, pokud je objekt v seznamu. Jinak false.
    bool Contains(T object)
    {
      for(LinkedListItem *item = m_first; item; item = item->next)
        if(item->data == object)
          return true;
      return false;
    }

    // Vraci prvek s indexem i. Pokud prvek s indexem i neexistuje, tak vyhodi vyjimku.
    T& At(int i)
    {
      for(LinkedListItem *item = m_first; item; item = item->next)
        if(item->index == i)
          return item->data;
      throw nonexistent();
    }

    // Vraci prvek s indexem i. Pokud prvek s indexem i neexistuje, tak je do pole pridan.
    T& operator[](int i)
    {
      LinkedListItem **p;
      
      for(p = &m_first; *p; p = &(*p)->next)
      {  
        if(i == (*p)->index)
          return (*p)->data;
          
        if(i < (*p)->index)
          break;
      }
      
      T t;
      return insert(p,t,i);
    }

    // Vraci index prvku object, pokud je v seznamu. Pokud neni, vyhodi vyjimku.
    int IndexOf(T object)
    {
      for(LinkedListItem *item = m_first; item; item = item->next)
        if(item->data == object)
          return item->index;
      throw nonexistent();
    }
    
    // Vraci iterator na zacatek seznamu. Iterator umoznuje prochazet pouze existujici
    // prvky pole.
    iterator Begin() { return iterator(m_first); }

    // Vraci iterator na konec seznamu. Iterator umoznuje prochazet pouze existujici prvky pole.
    iterator End() { return iterator(0); }

    // Odstrani prvek na danem indexu ze senamu a vrati ho.
    //NOTE: It must return the item by value, not by reference (it no longer exists in the list)
    T RemoveIndex(int i)
    {
      T t;
      LinkedListItem *p,*q;
      
      for(q = 0, p = m_first; p; q = p, p = p->next)
      {  
        if(i == p->index)
        {  
          if(q)
            q->next = p->next;
          else
            m_first = p->next;
          
          if(p == m_last) 
            m_last = q;
            
          t = p->data;
          delete p;
          m_size--;
          
          return t;
        } 
        
        if(i < p->index)
          throw nonexistent();
      }
      
      throw nonexistent();
    }

    // Skutecny pocet prvku v seznamu.
    int Size() { return m_size; }

  private:
    
    T &insert(LinkedListItem **p, T &object, int index)
    {
      LinkedListItem *item;
      
      item = new LinkedListItem;
      item->data = object;
      item->index = index;
      item->next = *p;
      
      if(!*p) m_last = item;
      *p = item;
      if(!m_first) m_first = item;
      
      m_size++;
      
      return item->data;
    }
};

#endif //_LINKEDLIST_H_
