#ifndef _ARRAYLIST_H_
#define _ARRAYLIST_H_

#include "ListExcept.h"

template <typename T> class ArrayList 
{
  private:
    
    struct ArrayListItem { bool exists; T data; };
    int m_size;
    int m_allocated;
    ArrayListItem *m_array;
    int m_last;
     
  public:
    
    // Iterator
    class iterator 
    { 
      public:
        iterator() : m_item(0), m_end(0) {}
        T &operator* () { return m_item->data; }
        bool operator!= (const iterator &it) { return m_item != it.m_item; }
        bool operator== (const iterator &it) { return m_item == it.m_item; }
        
        iterator &operator++ () 
        { 
          do {
            m_item++;
          } while(m_item < m_end && !m_item->exists);
          
          return *this; 
        }
        
      private:
        iterator(ArrayListItem *item, ArrayListItem *end) : m_item(item), m_end(end) {}
        ArrayListItem *m_item, *m_end;
      
      friend class ArrayList;
    };
   
    // Constructor
    ArrayList() : m_size(0), m_allocated(0), m_array(0), m_last(-1) {}
    
    // Prida objekt (object) na danou pozici (index) v seznamu. Index muze ukazovat i za konec
    // seznamu.
    void Add(int index, T object)
    {     
      if(index < 0)
        throw invalid_index();
    
      Ensure(index + 1);
      
      if(m_array[index].exists)
        throw existing();
      
      m_array[index].exists = true;
      m_array[index].data = object;
      if(index > m_last) m_last = index;
      m_size++;
    }

    // Prida objekt (object) na konec seznamu.
    void Add(T object) { Add(m_last + 1, object); }


    // Vrati true, pokud je objekt v seznamu. Jinak false.
    bool Contains(T object)
    {
      for(int i = 0; i < m_allocated; i++)
        if(m_array[i].exists && m_array[i].data == object)
          return true;
      return false;
    }

    // Vraci prvek s indexem i. Pokud prvek s indexem i neexistuje, tak vyhodi vyjimku.
    T& At(int i)
    {
      if(i < 0 || i >= m_allocated || !m_array[i].exists)
        throw nonexistent();
      else
        return m_array[i].data;
    }

    // Vraci prvek s indexem i. Pokud prvek s indexem i neexistuje, tak je do pole pridan.
    T& operator[](int i)
    {
      if(i < 0 || i >= m_allocated || !m_array[i].exists)
        Add(i,T());
      
      return m_array[i].data;
    }

    // Vraci index prvku object, pokud je v seznamu. Pokud neni, vyhodi vyjimku.
    int IndexOf(T object)
    {
      for(int i = 0; i < m_allocated; i++)
        if(m_array[i].exists && m_array[i].data == object)
          return i;
      throw nonexistent();
    }
   
    // Vraci iterator na zacatek seznamu. Iterator umoznuje prochazet pouze existujici
    // prvky pole.
    iterator Begin() { return ++iterator(m_array - 1, m_array + m_allocated); }

    // Vraci iterator na konec seznamu. Iterator umoznuje prochazet pouze existujici prvky pole.
    iterator End() { return iterator(m_array + m_allocated, m_array + m_allocated); }

    // Odstrani prvek na danem indexu ze senamu a vrati ho.
    //NOTE: It must return the item by value, not by reference (it no longer exists in the list)
    T RemoveIndex(int i)
    {
      if(i >= m_allocated || !m_array[i].exists)
        throw nonexistent();
      
      m_array[i].exists = false;
      
      while(m_last >= 0 && !m_array[m_last].exists)
        m_last--;
      
      return m_array[i].data;
    }

    // Skutecny pocet prvku v seznamu.
    int Size() { return m_size; }
     
    // Velikost vnitrniho pole.
    int Capacity() { return m_allocated; }
    
    // Zajisti, aby velikost vnitrniho pole byla alespon "capacity".
    void Ensure(int capacity)
    {
      int i,n;  
      ArrayListItem *newarray;
    
      if(capacity > m_allocated)
      {  
        for(n = 1; n < capacity; n <<= 1);
        newarray = new ArrayListItem[n];
        
        for(i = 0; i < m_allocated; i++)
          newarray[i] = m_array[i];
        for(i = m_allocated; i < n; i++)
          newarray[i].exists = false;
        
        delete[] m_array;
        m_array = newarray;
        m_allocated = n;
      }
    }
};

#endif //_ARRAYLIST_H_
