/**
 * \file mp3iterator.h
 * @short Declaration of class MP3Iterator
 */

#ifndef _MP3ITERATOR_H_
#define _MP3ITERATOR_H_

#include "bitstream.h"
#include "mp3frame.h"
#include "mp3stream.h"

/** @short Wrapper class for MP3 stream
 *
 * This class should used always to access frames 
 * from an MP3 stream. Frames are deallocated 
 * automatically when they are not needed, so it's
 * really dangerous to keep pointer to more than one
 * frame. This class does not allow it, while 
 * providing tranesparent acces to MP3Frame methods.
 */
class MP3Iterator
{
  public:
    
    /**
     * Constructor.
     *
     * Construts an MP3Stream and reads first frame.
     *
     * @param bs Input Bitstream
     * @param type Write mode as defined in MP3Frame
     */
    MP3Iterator(Bitstream &bs, int type);
    
    /**
     * Destructor.
     *
     * Deletes MP3Stream with all allocated frames.
     *
     */
    ~MP3Iterator();
    
    /**
     * Redirection to method of MP3Frame.
     *
     * This way all methods are accessible and no one
     * needs to keep a pointer to real frame
     *
     * @return Current frame
     */
    MP3Frame *operator-> () const; 
    
    /**
     * Moves to next frame.
     *
     * Also deletes unneded frames.
     *
     * @return itself
     */
    MP3Iterator &operator++ ();

  private:
    MP3Frame *m_frame; //Current frame in stream
    MP3Stream *m_stream; //MP3 stream to read frames from
};

#endif // _MP3ITERATOR_H_
