/**
 * \file mp3iterator.cpp
 * @short Implementation of class MP3Iterator
 */

#include "mp3iterator.h"

MP3Iterator::MP3Iterator(Bitstream &bs, int type = MP3Frame::normal)
{
  m_stream = new MP3Stream(bs, type); //Also reads first frame
  m_frame = m_stream->First(); //Get that first frame
}

MP3Iterator::~MP3Iterator()
{
  delete m_stream;
}

MP3Frame *MP3Iterator::operator-> () const
{ 
 return m_frame; //Redirection to current frame
}

MP3Iterator &MP3Iterator::operator++ () 
{ 
  m_frame = m_frame->Next(); //Move to next frame
  
  //In fastwrite mode only data from current frame are
  //  needed, so previous frames could be safely deleted
  if( m_stream->WriteMode() != MP3Frame::normal )
    m_stream->SeekTo(m_frame);
  
  return *this; 
}
