/**
 * \file kraken.cpp
 * @short Main program, delegates everything to MP3Core
 */

#include "mp3core.h"

int main(int argc, const char *argv[])
{
  MP3Core core;
  if(!core.Params(argc, argv)) //Parse command line arguments
  {  
    core.ShowHelp(argv[0]);
    return 1;
  }

  return core.Process() ? 0 : 1; //Do what should be done
}

/*! \mainpage
 *
 * \section intro_sec Introduction
 *
 * Kraken is a tool for various lossless operations on MP3 files.
 * It can join files, change volume, cut time from both beginning
 * and end, show information about file and autodetect digital 
 * silence. It also has a limited ID3 tag editing capability.
 * 
 * You can obtain a list of parameters by executing
 * \code kraken -h \endcode
 *
 * \section implem_sec Implementation
 * 
 * The top-level class is MP3Core, which parses commandline 
 * parameters and starts processing.
 *
 * Processing may need two passes, in first pass the frames are
 * counted and silence is detected. In second pass the results are
 * written.
 *
 * Files are read via Bitstream, which can be constructed on top 
 * of multiple files, so these files area automatically joined.
 *
 * A MP3 File consists of so-called frames, every frame is self-contained,
 * ie. there's no global header of MP3 file. A Frame is handled in class 
 * MP3Frame, which is for sure the most important in the project. Every 
 * frame consists of different headers (FrameHeader, DataHeader and 
 * ChannelHeader for every channel) and audio data for every channel 
 * (in stereo file), and both "granules". Frame is divided to two granules
 * just to save precious space on frame headers. 
 *
 * The class MP3Frame with cooperation with MP3Stream handles a so-called
 * "bit reservoir" (frame data can be stored in few previous frames, more
 * information in documentation of MP3Frame).
 */
