/**
 * \file frameheader.cpp
 * @short Implementation of class FrameHeader
 */

#define FRAMEHEADER
#include "frameheader.h"

FrameHeader::FrameHeader(Bitstream &bs) : m_fh(bs) {}
    
void FrameHeader::Write(Bitstream &bs)
{
  m_fh.Write(bs);
}
    
int FrameHeader::Size() const
{
  return size;
}
    
int FrameHeader::Bitrate() const
{ 
  return bitrate_table[m_fh^ID][m_fh^layer][m_fh^bitrate_index];
}
    
int FrameHeader::Version() const
{ 
  return version_table[m_fh^IDex][m_fh^ID];
}
    
int FrameHeader::Layer() const
{
  return layer_table[m_fh^layer];
}
    
bool FrameHeader::isCopyrighted() const
{
  return (m_fh^copyright) != 0;
}
    
bool FrameHeader::isOriginal() const
{
  return (m_fh^original) != 0;
}

bool FrameHeader::isCRC() const
{
  return (m_fh^protection_bit) == 0;
}
    
int FrameHeader::Frequency() const
{
  return frequency_table[m_fh^IDex][m_fh^ID][m_fh^frequency];
}
    
int FrameHeader::Mode() const
{
  return m_fh^mode;
}
    
bool FrameHeader::isIntensStereo() const
{
  return (m_fh^mode_extension) & 1 != 0;
}
    
bool FrameHeader::isMSstereo() const
{
  return (m_fh^mode_extension) & 2 != 0;
}
    
int FrameHeader::NumChannels() const
{
  return ((m_fh^mode) == single_channel) ? 1 : 2;
}
    
int FrameHeader::NumGranules() const
{
  return (Version() == 1) ? 2 : 1;
}
    
int FrameHeader::FrameSize() const
{
  return (m_fh^ID ? 144 : 72) * Bitrate() * 1000 / Frequency() + (m_fh^padding_bit);
}
    
bool FrameHeader::isValid() const
{ //Only a few fields could be checked for validity, -1 means invalid value
  return Frequency() != -1 && Bitrate() != -1 && Layer() != -1 && Version() != -1 && Layer() == 3; 
}
    
void FrameHeader::Enlarge()
{
  m_fh.Set(bitrate_index, (m_fh^bitrate_index) + 1); //Resize to next bitrate
}
