/**
 * \file except.h
 * @short Classes for exceptions
 */

#ifndef _EXCEPT_H_
#define _EXCEPT_H_

#include <stdexcept>

/**
 * @short Thrown when file can't be opened
 *
 * filename() returns the failed file
 */
class eOpenFailed : public std::exception
{
  public:
    eOpenFailed(const char *filename) { m_filename = filename; }
    const char *filename() const { return m_filename; }
  private:
    const char *m_filename;
};

/**
 * @short Thrown at EOF condition
 *
 * bytes_read() returns number of bytes succesfully read
 * type() is either eEOF::partial od eEOF::final
 */
class eEOF : public std::exception
{
  public:
    enum { partial, final };
    eEOF(int type, int bytes) { m_type = type; m_bytes = bytes; }
    int bytes_read() const { return m_bytes; }
    int type() const { return m_type; }
  private:
    int m_bytes;
    int m_type;
};

/**
 * @short General error (cannot continue)
 *
 * Details are in what()
 */
class eCannotProceed : public std::runtime_error
{
  public:
    eCannotProceed(const char *str) : runtime_error(str) {}
};

#endif //_EXCEPT_H_
