/**
 * \file conv.cpp
 * @short Implementation of class Conv
 */

#include <sstream>
#include <iomanip>
#include <cctype>

#include "conv.h"
#include "mp3_format.h"

std::string Conv::Frame2Time(int framenum)
{
  int time = framenum * mp3::frametime; //Time in miliseconds
  std::stringstream stream;
  
  //Format the time (minutes:seconds.miliseconds)
  stream << (time / 60000) << ':' << std::setw(2) << std::setfill('0') 
          << (time % 60000 / 1000) << '.' << std::setw(3) << (time % 1000);
  return stream.str();
}

int Conv::Time2Frame(const char *ch)
{
  int time = 0;
  
  while(*ch >= '0' && *ch <= '9') //First number
  {  
    time = time * 10 + *ch - '0';
    ch++;
  }
  
  if(*ch++ == ':') //If there is ':', first number was
  {                // minute, otherwise it was second
    int sec = 0;
    while(*ch >= '0' && *ch <= '9')
    {  
      sec = sec * 10 + *ch - '0';
      ch++;
    }
    time = 60 * time + sec;
  }
  
  time *= 1000;
  if(*ch++ == '.') //Miliseconds
  {  
    int milisec = 0;
    while(*ch >= '0' && *ch <= '9')
    {  
      milisec = milisec * 10 + *ch - '0';
      ch++;
    }
    time += milisec;
  }
  
  return time / mp3::frametime;  
}    

int Conv::dB2Gain(const char *gainstr)
{
  double dB;
  
  //FIXME: What is a simple portable C++ way to convert a string to number?
  (std::stringstream(gainstr)) >> dB; //Brackets must be here to compile in GCC!
  
  return int(dB / 1.5 + 0.5); //1.5dB is one MP3 unit
}
