/**
 * \file audiodata.h
 * @short Declaration of class AudioData
 */

#ifndef _AUDIODATA_H_
#define _AUDIODATA_H_

#include "bitstream.h"

/**
 * @short Container for data bytes of frame
 *
 * This class just keeps audio data bytes.
 */
class AudioData
{
  public:
    
    /**
     * Constructor
     *
     * Reads data bits from Bitstream
     *
     * @param num	Maximum number of data bytes
     * @param min	Number of required data bytes
     * @param bs	Bitstream to read data from
     */
    AudioData(int num, int min, Bitstream &bs);
    
    /**
     * Destructor
     *
     * Deletes allocated data 
     *
     * @return 
     */
    ~AudioData();
    
    /**
     * Writes all data bits
     *
     * @param bs Output Bitstream
     */
    void Write(Bitstream &bs) const;
    
    /**
     * Writes subset of data
     * 
     * Addresed by byte number (not bit number).
     * Checks bounds via assert() .
     *
     * @param bs	Output Bitstream
     * @param start	First byte
     * @param end	The byte after last written byte
     */
    void Write(Bitstream &bs, int start, int end) const;
    
  private:
    int m_size; //Number of data bytes
    char *m_data; //Data bytes
};

#endif //_AUDIODATA_H_
