/**
 * \file audiodata.cpp
 * @short Implementation of class AudioData
 */

#include <cassert>
#include "audiodata.h"
#include "except.h"

#ifdef DEBUG
#include <iostream>
#endif

AudioData::AudioData(int num, int min, Bitstream &bs)
{ 
  m_size = num;
  m_data = new char[num];
  
  //Read data, if at least min bytes was read (required audiodata), it's OK
  try {
    bs.ReadBytes(m_data, num);
  }
  catch(eEOF e)
  {
    int realnum = e.bytes_read();
    
    #ifdef DEBUG
    std::cout << "read " << realnum << " bytes, " << min << " needed" << std::endl;
    #endif
    
    if(realnum >= min)
      m_size = realnum;
    else
      throw e;
  }
}
    
AudioData::~AudioData()
{
  delete[] m_data;
}
  
void AudioData::Write(Bitstream &bs) const
{
  bs.WriteBytes(m_data, m_size);
}

void AudioData::Write(Bitstream &bs, int start, int end) const
{
  assert(start <= end);
  assert(end <= m_size);
  bs.WriteBytes(m_data + start, end - start);
}
