#ifndef _TETRIS_NET_H
#define _TETRIS_NET_H

#include "tetris.h"

#define FLAG_END   1
#define FLAG_BRICK 2
#define FLAG_BOARD 4
#define FLAG_STATS 8

#define DEFAULT_PORT "2005"

const char *net_init_client(char *host, char *port);
const char *net_init_server(char *port);
void net_send_brick(int bricknum, T_COORD *c);
void net_send_board(T_GAME *game);
void net_send_stats(T_STATS *stats);
void net_send_quit();
int net_receive(T_GAME *game, int *bricknum, T_COORD *c);
unsigned int net_wait_server();
void net_wait_client(unsigned long seed);

#endif
